<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_DataWriter_Discussion_Thread extends XFCP_sonnbStopSpamHere_DataWriter_Discussion_Thread
{
    protected function _discussionPreSave()
    {
        parent::_discussionPreSave();
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_MODERATE]))
        {
            $this->set('discussion_state', 'moderated');
        }
    }
    
    protected function _discussionPostSave(array $messages)
    {
        parent::_discussionPostSave($messages);
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_MODERATE]))
        { 
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_MODERATE]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_MODERATE,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_MODERATE]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_MODERATE]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_ALLOW]))
        {
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_ALLOW]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_ALLOW,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_ALLOW]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_ALLOW]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_CONVERSATION]))
        {
            sonnbStopSpamHere_Model_Moderate::sendPC(
                XenForo_Visitor::getInstance(),
                XenForo_Link::buildPublicLink('threads', $this->getMergedData()),
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_CONVERSATION]
            );
            
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_CONVERSATION]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_CONVERSATION,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_CONVERSATION]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_CONVERSATION]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_REPORT]))
        {           
            sonnbStopSpamHere_Model_Moderate::sendReport(
                'post',
                array(
                    'post_id' => $this->get('first_post_id'),
                    'user_id' => $this->get('user_id')
                ),
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_REPORT]
            );
            
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_REPORT]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_REPORT,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_REPORT]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_THREAD_REPORT]);
        }
    }
    
    public function addLog($type, $action, array $data = array())
    {
        $sshModel = new sonnbStopSpamHere_Model_SSH;
        $sshModel->saveLog(
            array(
                'content_type' => sonnbStopSpamHere_Model_SSH::TYPE_THREAD,
                'content_id' => $this->get('thread_id'),
                'log_type' => $type,
                'data' => serialize($data),
                'action' => $action
            )
        );
    }
}